// MDD Baker.js
//
// this is polygon script to bake .mdd file data to target polygon object.
// place it into ~/Library/Application Support/Cheetah3D/scripts/Polygonobj folder.
//
// v.20101016 first.
// v.20101017 bug fixed. zup/yup option added.
// v.20101018 flip bug fixed.
// v.20120828 fix crash bug
//
// Hiroto Tsubaki - tg@tres-graficos.jp

var file = null;

var total_frames;
var total_points;
var dt;

function buildUI( obj ) {
	obj.setParameter("name", "MDD Baker");
	
	obj.addParameterSeparator("Target Polygon");
	obj.addParameterLink("target", true, false);
	
	obj.addParameterSeparator("MDD file");
	obj.addParameterButton( "set .mdd file", "set", "setMDD" );
	obj.addParameterSelector( "coordinate system", [ "zup", "yup" ], false, true );
  //obj.addParameterInt("coordinate system", 0, 0, 1, false, true);
	
	obj.addParameterString( "mdd file path", "", false );
	
	// must be int, but smooth animation
	obj.addParameterSeparator("Anim Frame");
	obj.addParameterFloat( "frame", 0, 0, 100000, true, true);
}

function setMDD( obj ) {
	
	var path = OS.runOpenPanel('mdd');
	if (path == null) return;
	
	obj.setParameter("mdd file path", path );
	
	file = new File( path );
	
	initMDDFile();
}

function initMDDFile() {
	file.open( READ_MODE, BIG_ENDIAN );
	
	total_frames = file.readInt();
	total_points = file.readInt();
	dt = file.readFloat();
	
	file.close();
}

function buildObject( obj ) {
	
	// reload backup
	if ( file == null && obj.getParameter("mdd file path") != '' ) {
		file = new File( obj.getParameter("mdd file path") );
		if (file. exist()) {
			initMDDFile();
		} else {
			OS.messageBox( "MDD File Error", "You have to relocate .mdd file.\nmdd filename:"+ file.lastPathComponent() );
			obj.setParameter("mdd file path", "");
			file = null;
			total_frames = 0;
			total_points = 0;
		}
	}
	
	var b_mat;
	switch (parseInt( obj.getParameter("coordinate system") ) ) {
		case 0:
			var i_mat = new Mat4D();
			i_mat.m11 = -1;
			
			b_mat = new Mat4D(ROTATE, 90, 0, 0);
			b_mat = i_mat.multiply( b_mat );
			
			break;
		case 1:
			b_mat = new Mat4D();
			b_mat.m22 = -1;
			
			break;
	}
	
	var tar = obj.getParameter("target");
	if (!tar) return;
	
	if (tar.family() != NGONFAMILY) {
		return;
	}
	
	var frame = Math.floor( obj.getParameter("frame") );
	
	if (frame >= total_frames) { // too much frame count;
		return;
	}
	
	var core = tar.core();
	var points = core.vertexCount();
	
	if (file == null || points != total_points) { // not match vertices count
		print(points + ':' + total_points );
		return;
	}
	
	file.open( READ_MODE, BIG_ENDIAN );
	if ( !file.isOpen() ) return;
	
	file.readInt();
	file.readInt();
	file.seek( (4 * total_frames) + ( total_points * frame * 4 * 3 ), SEEK_CUR );
	
	var i;
	var vec = new Vec3D();
	for ( i = 0; i < total_points; i++ ) {
		vec.set( file.readFloat(), file.readFloat(), file.readFloat() );
		core.setVertex( i , b_mat.multiply(vec) );
	}
	
	file.close();
	
	tar.update();
}
